﻿var divsArray = new Array();
var currItem = 0;
var timeout = 5;
var draggedBox = null;
var offset = null;

document.onmouseup = mouseUp;
document.onmousemove = mouseMove;

function mousePos(evt)
{
  evt = evt || window.event;

  if(evt.pageX){
    return {x:evt.pageX, y:evt.pageY};
  }
  else if(evt.clientX){
    return{
      x:evt.clientX + document.body.scrollLeft + document.body.clientLeft,
      y:evt.clientY + document.body.scrollTop  - document.body.clientTop
    };
  }
  else{
    return {x:0, y:0};
  }
}

function startDrag(obj)
{
  if(!obj) return;
  draggedBox = obj;
  xOff = 0;
  yOff = 0;
  while(obj.offsetParent){
    xOff += obj.offsetLeft;
    yOff += obj.offsetTop;
    obj = obj.offsetParent;
  }
  
  obj.onmousedown = function(evt)
  {
    coords = mousePos(evt);
    xOff = coords.x - xOff;
    yOff = coords.y - yOff; 
    offset = {x:xOff, y:yOff};
  }
}

function mouseUp(evt)
{
  draggedBox = null;
}

function mouseMove(evt)
{
  coords = mousePos(evt);

  if(draggedBox){
    draggedBox.style.position = "absolute";
    draggedBox.style.top = (coords.y - offset.y) + "px";
    draggedBox.style.left = (coords.x - offset.x) + "px";
    return false;
  }
}

function startRequest(param)
{
  var rssDiv = document.getElementById("rssBox");
  rssDiv.innerHTML = "Trwa wczytywanie danych...";
  url = "http://localhost/dane.php?url=" + param;
  startGETRequest(url, onComplete, onEnd);
}

function onEnd()
{
}

function startRSSShow()
{
  if(divsArray.length < 1) return;

  if(++currItem >= divsArray.length) currItem = 0;
  if(currItem == 0)
    prevItem = divsArray.length - 1;
  else
    prevItem = currItem - 1;

  divsArray[prevItem].style.display = "none";
  divsArray[currItem].style.display = "block";

  setTimeout("startRSSShow();", timeout * 1000);
}

function onComplete(text, xml)
{
  if(text == 'error'){
    var rssDiv = document.getElementById("rssBox");
    rssDiv.innerHTML = "Wiadomości RSS nie są dostępne.";
  }
  else{
    var rssBox = document.getElementById("rssBox");
    rssBox.innerHTML = "";
    items = text.split("\n\n");
    var count = 0;
    for(i = 0; i < items.length; i++){
      elements = items[i].split("\n");

      var div = document.createElement("div");

      if(count > 0) div.style.display = "none"
      else div.style.display = "block";

      div.id = "rssDiv" + count++;
      div.className = "rssBoxDiv";

      rssBox.appendChild(div);
      div.style.width = (div.parentNode.clientWidth - 6) + "px";
      div.style.height = div.parentNode.offsetHeight + "px";

      var pTitle = document.createElement("p");
      pTitle.className = "pTitle";
      pTitle.innerHTML = elements[0];
      div.appendChild(pTitle);

      var pDate = document.createElement("p");
      pDate.className = "pDate";
      pDate.innerHTML = elements[1];
      div.appendChild(pDate);

      var pDescription = document.createElement("p");
      pDescription.className = "pDescription";
      pDescription.innerHTML = elements[3];
      div.appendChild(pDescription);

      var pLink = document.createElement("a");
      pLink.className = "pLink";
      pLink.innerHTML = "Więcej";
      pLink.href = elements[2];
      div.appendChild(pLink);

      divsArray.push(div);
    }
    setTimeout("startRSSShow();", timeout * 1000);
  }
}